#include <p30fxxxx.h>
#include <timer.h>

/*******************************************************************
*    Function Name: ConfigIntTimer1                                *
*    Description:   This Function Configures Interrupt and sets    *
*                   Interrupt Priority                             *
*    Return Value:  None                                           *
*******************************************************************/

void ConfigIntTimer1(unsigned int config)
{
    IFS0bits.T1IF = 0;                   /* clear IF bit */
    IPC0bits.T1IP = (config &0x0007);    /* assigning Interrupt Priority */
    IEC0bits.T1IE = (config &0x0008)>>3; /* Interrupt Enable /Disable */
}
